<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Components\Param;

use Core\Model\UI\BaseControl;
use RealEstates\AdminModule\Model\Params;

class ParamsGrid extends BaseControl
{
	/** @var Params */
	protected $propertyParamsService;

	public function __construct(Params $propertyParams)
	{
		$this->propertyParamsService = $propertyParams;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		$grid->setRememberState(false);
		$grid->setSortable();
		$grid->setSortableHandler('paramsGrid:gridSortableRow!');

		$qb = $this->propertyParamsService->getEr()->createQueryBuilder('pp')->orderBy('pp.position', 'ASC');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'default.title', 'Settings:editParam');
		$grid->addColumnText('description' ,'default.description');
		$grid->addColumnNumber('pricePerUnit', 'realEstates.paramsGrid.pricePerUnit')->setFormat(0, ',', ' ');
		$grid->addColumnText('unit', 'realEstates.paramsGrid.unit');

		// Filter
		$grid->addFilterText('title', '');
		$grid->addFilterText('unit', '');

		// Actions
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		// Columns prototype
		$grid->getColumn('unit')->getElementPrototype('td')->class[] = 'w1nw';

		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->propertyParamsService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * =================  Grid function
	 */

	public function handleGridSortableRow()
	{
		$presenter = $this->getPresenter();
		$request   = $presenter->getHttpRequest();
		$id        = $request->getPost('id', null);
		$position  = $request->getPost('position', null);

		if ($id != null && $position != null && $this->propertyParamsService->getEr()->setPosition($id, $position)) {
			$presenter->flashMessageSuccess('default.positionChanged');
		} else {
			$presenter->flashMessageDanger('default.positionChangeFailed');
		}

		$presenter->redrawControl('flashes');
	}
}
