<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Caching\Cache;
use Nette\Neon\Neon;
use Nette\Utils\ArrayHash;
use RealEstates\AdminModule\Model\Settings;
use RealEstates\FrontModule\Model\Propertys as FrontPropertys;

class SettingsForm extends BaseControl
{
	/** @var array */
	public $data;

	/** @var Settings */
	protected $settingsService;

	/** @var FrontPropertys */
	protected $frontPropertysService;

	public function __construct(Settings $settings, FrontPropertys $frontPropertys)
	{
		$this->settingsService       = $settings;
		$this->frontPropertysService = $frontPropertys;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();

		foreach ($this->getData() as $k => $data) {
			if (!is_array($data)) {
				$data = ['value' => $data, 'type' => 'text'];
			}

			switch ($data['type']) {
				case 'float':
					$data['value'] = str_replace(',', '.', $data['value']);
					$c             = $form->addText($k, 'realEstates.settings.' . $k)->setType('number')->setAttribute('step', .01);
					break;
				case 'integer':
					$c = $form->addText($k, 'realEstates.settings.' . $k)->setType('number');
					break;
				default:
					$c = $form->addText($k, 'realEstates.settings.' . $k);
			}

			if (isset($data['required']) && $data['required'] === true)
				$c->setRequired();

			$c->setDefaultValue($data['value']);
		}

		$form->addSaveCancelControl();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			unset($values->saveControl);
			$this->settingsService->updateData((array) $values);
			$this->frontPropertysService->getCache()->clean([Cache::TAGS => FrontPropertys::CACHE_NAMESPACE]);
			$this->getPresenter()->flashMessageSuccess('realEstates.settingsForm.updated');
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	/*******************************************************************************************************************
	 * ============================== Get / Set
	 */

	public function getData()
	{
		if (!$this->data) {
			$this->data = $this->settingsService->getData();
		}

		return $this->data;
	}
}
