<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use RealEstates\Model\Entities\Property;
use RealEstates\Model\Entities\RealEstateListener;

/**
 * Class Propertys
 * @package RealEstates\AdminModule\Model
 *
 * @method Property|object|null getReference($id)
 * @method Property[]|null getAll()
 * @method Property|null get($id)
 */
class Propertys extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Property::class;

	/** @var RealEstateListener */
	protected $realEstateListener;

	public function __construct(RealEstateListener $realEstateListener)
	{
		$this->realEstateListener = $realEstateListener;
	}

	public function getWithJoins($id)
	{
		$qb = $this->getEr()->createQueryBuilder('p')->where(is_array($id) ? 'p.id IN (:id)' : 'p.id = :id')->setParameter('id', $id)
			->addSelect('r, t, a, g, imgs, pp, param')
			->leftJoin('p.rooms', 'r')->leftJoin('p.type', 't')->leftJoin('p.author', 'a')
			->leftJoin('p.gallery', 'g')->leftJoin('g.images', 'imgs')
			->leftJoin('p.params', 'pp')->leftJoin('pp.param', 'param');

		return is_array($id) ? $qb->getQuery()->getResult() : $qb->getQuery()->getOneOrNullResult();
	}

	public function clearFrontCache()
	{
		$this->realEstateListener->clearCache();
	}

	/**
	 * @param int $id
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function resetPdfDownloads($id)
	{
		if ($entity = $this->get($id)) {
			$entity->pdfDownloads = 0;
			$this->em->persist($entity)->flush();

			return true;
		}

		return false;
	}

	/**
	 * @param int $id
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function resetViews($id)
	{
		if ($entity = $this->get($id)) {
			$entity->views = 0;
			$this->em->persist($entity)->flush();

			return true;
		}

		return false;
	}
}
