<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Model;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Helpers\BaseEntityService;
use RealEstates\Model\Entities\Room;

/**
 * Class Rooms
 * @package RealEstates\AdminModule\Model
 *
 * @method Room|object|null getReference($id)
 * @method Room[]|null getAll()
 * @method Room|null get($id)
 */
class Rooms extends BaseEntityService
{
	protected $entityClass = Room::class;

	/**
	 * @param $value
	 *
	 * @return Room|null|object
	 */
	public function getByValue($value)
	{
		return $this->getEr()->findOneBy(['value' => $value]);
	}

	/**
	 * Přidá novou hodnotu. Pokud existuje vyhodí exception, jinak vrátí hodnotu nebo null
	 *
	 * @param $value
	 *
	 * @return null|Room
	 * @throws InvalidArgumentException
	 */
	public function add($value)
	{
		if ($this->getByValue($value)) {
			throw new InvalidArgumentException();
		}

		try {
			$room = new Room($value);
			$this->em->persist($room)->flush();

			return $room;
		} catch (\Exception $e) {
		}

		return null;
	}

	/**
	 * Upraví hodnotu. Pokud existuje vyhodí exception, jinak vrátí hodnotu nebo null
	 *
	 * @param Room   $room
	 * @param string $value
	 *
	 * @return null|Room
	 * @throws InvalidArgumentException
	 */
	public function update(Room $room, string $value)
	{
		if ($room->value != $value && $this->getByValue($value)) {
			throw new InvalidArgumentException();
		}

		try {
			$room->value = $value;
			$this->em->persist($room)->flush();

			return $room;
		} catch (\Exception $e) {
		}

		return null;
	}

	/**
	 * @param $id
	 *
	 * @return bool|string
	 */
	public function remove($id)
	{
		if ($entity = $this->get($id)) {
			if ($entity->getPropertys()->count()) {
				return 'realEstates.rooms.cannotDeleteContainPropertys';
			}

			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}

}