<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Model;

use Core\Model\Entities\Repository\SortableRepository;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use RealEstates\Model\Entities\Variant;

/**
 * Class Variants
 * @package RealEstates\AdminModule\Model
 *
 * @method Variant|object|null getReference($id)
 * @method Variant[]|null getAll()
 * @method Variant|null get($id)
 * @method SortableRepository getEr()
 */
class Variants extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Variant::class;
}