<?php declare(strict_types = 1);

namespace RealEstates\FrontModule\Components;

use Core\Model\UI\BaseControl;
use RealEstates\FrontModule\Model\Propertys;
use RealEstates\Model\Entities\Property;

class PropertysList extends BaseControl
{
	/** @var Propertys */
	protected $propertysService;

	/** @var Property[] */
	protected $propertys;

	/** @var Property[] */
	protected $propertysFiltered;

	/** @var PropertysFilter */
	protected $propertysFilterControl;

	public function __construct(Propertys $propertys)
	{
		$this->propertysService = $propertys;
	}

	public function render()
	{
		$this->template->propertys = $this->getFilteredPropertys();
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ============================== Get / Set
	 */

	public function setPropertysFilterControl(PropertysFilter $propertysFilter)
	{
		$this->propertysFilterControl = $propertysFilter;
	}

	public function getPropertys()
	{
		if (!$this->propertys) {
			$this->propertys = $this->propertysService->getPublished();
		}

		return $this->propertys;
	}

	public function getFilteredPropertys()
	{
		if (!$this->propertysFiltered) {
			$filters                 = [
				'type'       => $this->propertysFilterControl->getTypeFilter(),
				'rooms'      => $this->propertysFilterControl->getRoomsFilter(),
				'price'      => $this->propertysFilterControl->getPriceFilter(),
				'more'       => $this->propertysFilterControl->getMoreFilter(),
				'usableArea' => $this->propertysFilterControl->getUsableAreaFilter(),
			];
			$this->propertysFiltered = $this->propertysService->proceedFilter($this->getPropertys(), $filters);
		}

		return $this->propertysFiltered;
	}
}
