<?php declare(strict_types = 1);

namespace RealEstates\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

class Variant
{
	use MagicAccessors;

	/** @var int */
	public $id;

	/** @var Property */
	public $property;

	/** @var string */
	public $title;

	/** @var Param[] */
	protected $params;

	/** @var int */
	public $price;

	/** @var int */
	public $priceVat;

	/** @var int */
	public $vat;

	/**
	 * @return int
	 */
	public function getPrice()
	{
		return $this->price;
	}

	/**
	 * @return int
	 */
	public function getPriceVat()
	{
		return $this->priceVat;
	}

	/**
	 * @param Param $param
	 *
	 * @return $this
	 */
	public function addParam(Param $param)
	{
		$this->params[] = $param;

		return $this;
	}

	/**
	 * @param Param[] $params
	 *
	 * @return $this
	 */
	public function setParams($params)
	{
		$this->params = $params;

		return $this;
	}
}
