<?php declare(strict_types = 1);

namespace RealEstates\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Doctrine\Common\Collections\Criteria;
use Doctrine\ORM\Query;
use RealEstates\Model\Entities\Filter;

/**
 * Class Filters
 * @package RealEstates\FrontModule\Model
 */
class Filters extends BaseFrontEntityService
{
	protected $entityClass = Filter::class;

	/**
	 * @return Criteria
	 */
	protected function publishedCriteria()
	{
		$expr     = Criteria::expr();
		$criteria = Criteria::create();

		return $criteria;
	}

	/**
	 * @param int|array|null $id
	 *
	 * @return array|mixed
	 * @throws Query\QueryException
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function getPublished($id = null)
	{
		$filters = $this->getEr()->createQueryBuilder('f', 'f.id')->addCriteria($this->publishedCriteria());

		if ($id)
			$filters->andWhere(is_array($id) ? 'f.id IN (:id)' : 'f.id = :id')->setParameter('id', $id);

		$filters = $filters->getQuery();

		if (is_numeric($id))
			return $filters->getOneOrNullResult(Query::HYDRATE_ARRAY);

		return $filters->getArrayResult();
	}

	/**
	 * @param string $value
	 *
	 * @return array|null
	 * @throws Query\QueryException
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function getByValue($value)
	{
		$filter = $this->getEr()->createQueryBuilder('f')->addCriteria($this->publishedCriteria())
			->andWhere('f.value = :value')->setParameter('value', $value);

		return $filter->getQuery()->getOneOrNullResult(Query::HYDRATE_ARRAY);
	}
}
