<?php declare(strict_types = 1);

namespace RealEstates\FrontModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\Common\Collections\Criteria;
use Doctrine\ORM\Query;
use RealEstates\Model\Entities\PropertyType;

/**
 * Class PropertyTypes
 * @package RealEstates\FrontModule\Model
 *
 * @method PropertyType|object|null getReference($id)
 * @method PropertyType[]|null getAll()
 * @method PropertyType|null get($id)
 */
class PropertyTypes extends BaseEntityService
{
	protected $entityClass = PropertyType::class;

	/**
	 * @return Criteria
	 */
	protected function publishedCriteria()
	{
		$expr     = Criteria::expr();
		$criteria = Criteria::create();

		return $criteria;
	}

	/**
	 * @param null|int|array $id
	 *
	 * @return array|mixed
	 * @throws Query\QueryException
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function getPublished($id = null)
	{
		$types = $this->getEr()->createQueryBuilder('pt', 'pt.id')->addCriteria($this->publishedCriteria());

		if ($id)
			$types->andWhere(is_array($id) ? 'pt.id IN (:id)' : 'pt.id = :id')->setParameter('id', $id);

		$types = $types->getQuery()->useResultCache(true, 60);

		if (is_numeric($id))
			return $types->getOneOrNullResult(Query::HYDRATE_ARRAY);

		return $types->getArrayResult();
	}

	/**
	 * @param string $title
	 *
	 * @return array|null
	 * @throws Query\QueryException
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function getByTitle($title)
	{
		$type = $this->getEr()->createQueryBuilder('pt')->addCriteria($this->publishedCriteria())
			->andWhere('pt.title = :title')->setParameter('title', $title);

		return $type->getQuery()->getOneOrNullResult(Query::HYDRATE_ARRAY);
	}
}
