<?php declare(strict_types = 1);

namespace RealEstates\Model\Entities;

use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="real_estates__property_param")
 * @ORM\Entity
 * @ORM\EntityListeners({"RealEstateListener"})
 */
class PropertyParam
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var float
	 * @ORM\Column(name="value", type="float", nullable=true)
	 */
	public $value;

	/**
	 * @var array|string
	 * @ORM\Column(name="description", type="array", nullable=true)
	 */
	protected $description;

	/**
	 * @var Property
	 * @ORM\ManyToOne(targetEntity="Property", inversedBy="params")
	 * @ORM\JoinColumn(name="property_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $property;

	/**
	 * @var Param
	 * @ORM\ManyToOne(targetEntity="Param", inversedBy="propertyParams")
	 * @ORM\JoinColumn(name="property_params_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $param;

	public function __construct($property, $param, $value)
	{
		$this->property = $property;
		$this->param    = $param;
		$this->value    = $value;
	}

	/******
	 * === Description
	 */

	public function getDescription() { return $this->description ?: $this->param->description; }

	public function setDescription($desc) { $this->description = !empty($desc) ? $desc : null; }
}
