<?php declare(strict_types = 1);

namespace RealEstates\Model\Entities;

use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="real_estates__variant_param")
 * @ORM\Entity
 * @ORM\EntityListeners({"RealEstateListener"})
 */
class VariantParam
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="pattern", type="string", nullable=true)
	 */
	protected $pattern;

	/**
	 * @var Variant
	 * @ORM\ManyToOne(targetEntity="Variant", inversedBy="params")
	 * @ORM\JoinColumn(name="variant_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $variant;

	/**
	 * @var Param
	 * @ORM\ManyToOne(targetEntity="Param", inversedBy="variants")
	 * @ORM\JoinColumn(name="param_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $param;

	public function __construct($variant, $param)
	{
		$this->variant = $variant;
		$this->param   = $param;
	}

	/******
	 * === Pattern
	 */

	public function getPatternRaw() { return $this->pattern; }

	public function getPattern() { return $this->pattern ?: $this->param->getPattern(); }

	public function getPricePerUnit() { return $this->param->pricePerUnit; }

	public function setPattern($pattern) { $this->pattern = $pattern ?: null; }
}
