<?php

namespace RealEstates\Model\Helpers;

use Core\Model\Helpers\BaseService;
use Core\Model\MathParser\Math;
use RealEstates\Model\Entities\Param;
use RealEstates\Model\Settings;

class Calculator extends BaseService
{
	/** @var Settings */
	protected $settings;

	public function __construct(Settings $settings)
	{
		$this->settings = $settings;
	}

	/**
	 * @param string $pattern
	 * @param int    $pricePerUnit
	 * @param int    $value
	 *
	 * @return int
	 */
	public function paramResult($pattern, $pricePerUnit, $value)
	{
		$pattern = $pattern . '*' . $this->settings->get('priceModify', 1);
		$pattern = str_replace('$ppu', $pricePerUnit, $pattern);
		$pattern = str_replace('$v', $value, $pattern);
		$pattern = str_replace(',', '.', $pattern);

		$math   = new Math();
		$result = $math->evaluate($pattern);

		return (int) ceil(round($result, 2));
	}

	/**
	 * @param float $area
	 *
	 * @return int
	 */
	public function basePlateSize($area)
	{
		return $area ? (int) ceil(round($area * $this->settings->get('basePlateModify', 1), 2)) : 0;
	}

	/**
	 * @param float $area
	 *
	 * @return int
	 */
	public function basePlateGroundFloorPrice($area)
	{
		return $area ? (int) ceil(round($this->basePlateSize($area) * $this->settings->get('basePlateHouseM2', 2500), 2)) : 0;
	}

	/**
	 * @param float $area
	 *
	 * @return int
	 */
	public function basePlateGaragePrice($area)
	{
		return $area ? (int) ceil(round($this->basePlateSize($area) * $this->settings->get('basePlateGarageM2', 2500), 2)) : 0;
	}

	/**
	 * @param float|int $price
	 *
	 * @return int
	 */
	public function vatPrice($price)
	{
		return (int) ceil(round($price * ($this->settings->get('vat') / 100 + 1), 2));
	}
}