<?php declare(strict_types = 1);

namespace RealEstates\Model;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Helpers\BaseEntityService;
use Nette\Neon\Neon;
use RealEstates\Model\Entities\Setting;

/**
 * Class Settings
 * @package RealEstates\Model
 */
class Settings extends BaseEntityService
{
	/** @var array */
	protected $data;

	/** @var string */
	protected $entityClass = Setting::class;

	/** @var string */
	protected $neonFile = CUSTOM_DIR . '/RealEstates/config/settings.neon';

	public function get($key, $default = null)
	{
		if (isset($this->getData()[$key])) {
			$v = $this->getData()[$key];
			settype($v['value'], $v['type']);

			return $v['value'];
		}

		return $default;
	}

	/**
	 * Načtení konfingu ze souboru
	 *
	 * @return array
	 */
	public function getData()
	{
		if (!$this->data) {
			$content = @file_get_contents($this->neonFile);
			if ($content) {
				$this->data = Neon::decode($content);
			}
		}

		return $this->data;
	}

	public function addCatalogDownload()
	{
		try {
			$this->getEr()->createQueryBuilder('s')->update()->set('s.value', 's.value + 1')
				->where('s.key = :key')->setParameter('key', 'catalog_downloads')
				->getQuery()->execute();

			return true;
		} catch (\Exception $e) {
			echo $e->getMessage();
		}

		return false;
	}
}
