<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180801010110 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE real_estates__author (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_3CE804865E237E06 (name), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE real_estates__param (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, price_per_unit INT DEFAULT 0 NOT NULL, unit VARCHAR(20) DEFAULT NULL, pattern VARCHAR(255) DEFAULT NULL, position INT NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, use_value_from_property VARCHAR(120) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE real_estates__property (id INT AUTO_INCREMENT NOT NULL, type_id INT DEFAULT NULL, room_id INT DEFAULT NULL, author_id INT DEFAULT NULL, gallery_id INT DEFAULT NULL, title VARCHAR(255) NOT NULL, alias VARCHAR(255) NOT NULL, ground_floor_area DOUBLE PRECISION UNSIGNED DEFAULT NULL, garret_area DOUBLE PRECISION UNSIGNED DEFAULT NULL, garage_area DOUBLE PRECISION UNSIGNED DEFAULT NULL, modify_available SMALLINT DEFAULT 1 NOT NULL, simple_params LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', introtext VARCHAR(255) DEFAULT NULL, text LONGTEXT DEFAULT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, publish_up DATETIME DEFAULT NULL, publish_down DATETIME DEFAULT NULL, is_offline SMALLINT DEFAULT 0 NOT NULL, views INT UNSIGNED DEFAULT 0 NOT NULL, INDEX IDX_6A6D61EDC54C8C93 (type_id), INDEX IDX_6A6D61ED54177093 (room_id), INDEX IDX_6A6D61EDF675F31B (author_id), UNIQUE INDEX UNIQ_6A6D61ED4E7AF8F (gallery_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE real_estates__property_param (id INT AUTO_INCREMENT NOT NULL, property_id INT DEFAULT NULL, property_params_id INT DEFAULT NULL, value DOUBLE PRECISION DEFAULT NULL, description LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_AC46A79C549213EC (property_id), INDEX IDX_AC46A79C4273C8B2 (property_params_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE real_estates__property_type (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, singular_title VARCHAR(255) NOT NULL, image VARCHAR(255) DEFAULT NULL, position INT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE real_estates__room (id INT AUTO_INCREMENT NOT NULL, value VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_1C3EA071D775834 (value), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE real_estates__setting (`key` VARCHAR(255) NOT NULL, value VARCHAR(255) DEFAULT NULL, PRIMARY KEY(`key`)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE real_estates__variant (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, position INT NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE real_estates__variant_param (id INT AUTO_INCREMENT NOT NULL, variant_id INT DEFAULT NULL, param_id INT DEFAULT NULL, pattern VARCHAR(255) DEFAULT NULL, INDEX IDX_EA8E64A33B69A9AF (variant_id), INDEX IDX_EA8E64A35647C863 (param_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');

		$this->addSql('ALTER TABLE real_estates__property ADD CONSTRAINT FK_6A6D61EDC54C8C93 FOREIGN KEY (type_id) REFERENCES real_estates__property_type (id)');
		$this->addSql('ALTER TABLE real_estates__property ADD CONSTRAINT FK_6A6D61ED54177093 FOREIGN KEY (room_id) REFERENCES real_estates__room (id)');
		$this->addSql('ALTER TABLE real_estates__property ADD CONSTRAINT FK_6A6D61EDF675F31B FOREIGN KEY (author_id) REFERENCES real_estates__author (id)');
		$this->addSql('ALTER TABLE real_estates__property ADD CONSTRAINT FK_6A6D61ED4E7AF8F FOREIGN KEY (gallery_id) REFERENCES gallery__album (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE real_estates__property_param ADD CONSTRAINT FK_AC46A79C549213EC FOREIGN KEY (property_id) REFERENCES real_estates__property (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE real_estates__property_param ADD CONSTRAINT FK_AC46A79C4273C8B2 FOREIGN KEY (property_params_id) REFERENCES real_estates__param (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE real_estates__variant_param ADD CONSTRAINT FK_EA8E64A33B69A9AF FOREIGN KEY (variant_id) REFERENCES real_estates__variant (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE real_estates__variant_param ADD CONSTRAINT FK_EA8E64A35647C863 FOREIGN KEY (param_id) REFERENCES real_estates__param (id) ON DELETE CASCADE');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE real_estates__property DROP FOREIGN KEY FK_6A6D61EDF675F31B');
		$this->addSql('ALTER TABLE real_estates__property_param DROP FOREIGN KEY FK_AC46A79C4273C8B2');
		$this->addSql('ALTER TABLE real_estates__variant_param DROP FOREIGN KEY FK_EA8E64A35647C863');
		$this->addSql('ALTER TABLE real_estates__property_param DROP FOREIGN KEY FK_AC46A79C549213EC');
		$this->addSql('ALTER TABLE real_estates__property DROP FOREIGN KEY FK_6A6D61EDC54C8C93');
		$this->addSql('ALTER TABLE real_estates__property DROP FOREIGN KEY FK_6A6D61ED54177093');
		$this->addSql('ALTER TABLE real_estates__variant_param DROP FOREIGN KEY FK_EA8E64A33B69A9AF');

		$this->addSql('DROP TABLE real_estates__author');
		$this->addSql('DROP TABLE real_estates__param');
		$this->addSql('DROP TABLE real_estates__property');
		$this->addSql('DROP TABLE real_estates__property_param');
		$this->addSql('DROP TABLE real_estates__property_type');
		$this->addSql('DROP TABLE real_estates__room');
		$this->addSql('DROP TABLE real_estates__setting');
		$this->addSql('DROP TABLE real_estates__variant');
		$this->addSql('DROP TABLE real_estates__variant_param');
	}
}
