<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Components\Param;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use RealEstates\AdminModule\Model\Params;
use RealEstates\Model\Entities\Param;

class ParamForm extends BaseControl
{
	/** @var Param */
	public $param;

	/** @var Params */
	protected $propertyParamsService;

	public function __construct(Params $propertyParams)
	{
		$this->propertyParamsService = $propertyParams;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$fromProperty = [
			'editableField'   => 'realEstates.paramForm.fromProperty.editableField',
			'groundFloorArea' => 'realEstates.paramForm.fromProperty.groundFloorArea',
			'garretArea'      => 'realEstates.paramForm.fromProperty.garretArea',
			'houseUsableArea' => 'realEstates.paramForm.fromProperty.houseUsableArea',
			'garageArea'      => 'realEstates.paramForm.fromProperty.garageArea',
		];

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addTextArea('description', 'realEstates.paramForm.description')->setAttribute('rows', 3);
		$form->addTextArea('description2', 'realEstates.paramForm.description2')->setAttribute('rows', 2);
		$form->addText('pricePerUnit', 'realEstates.paramForm.pricePerUnit')->setType('number')->setDefaultValue(0);
		$form->addText('unit', 'realEstates.paramForm.unit')->setMaxLength(20);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addSelect('useValueFromProperty', 'realEstates.paramForm.useValueFromProperty', $fromProperty);
		$form->addText('pattern', 'realEstates.paramForm.pattern')->setDefaultValue(Param::PATTERN)->setRequired();
		$form->addSaveCancelControl();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->param) {
				$param        = $this->param;
				$flashMessage = 'realEstates.paramForm.edited';
			} else {
				$param        = new Param($values->title);
				$flashMessage = 'realEstates.paramForm.added';
			}

			$param->title                = $values->title;
			$param->description          = $values->description;
			$param->description2         = $values->description2;
			$param->pricePerUnit         = $values->pricePerUnit;
			$param->isPublished          = $values->isPublished;
			$param->unit                 = $values->unit;
			$param->useValueFromProperty = $values->useValueFromProperty ?: null;
			$param->setPattern($values->pattern);

			$this->em->persist($param)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setParam($id)
	{
		$this->param = $this->propertyParamsService->get($id);

		if ($this->param) {
			$this['form']->setDefaults([
				'title'                => $this->param->title,
				'description'          => $this->param->description,
				'description2'         => $this->param->description2,
				'pricePerUnit'         => $this->param->pricePerUnit,
				'unit'                 => $this->param->unit,
				'isPublished'          => $this->param->isPublished,
				'useValueFromProperty' => $this->param->useValueFromProperty,
				'pattern'              => $this->param->getPattern(),
			]);

			if ($this->param->useValueFromProperty && array_key_exists($this->param->useValueFromProperty, $this['form']['useValueFromProperty']->getItems())) {
				$this['form']['useValueFromProperty']->setDefaultValue($this->param->useValueFromProperty);
			}
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
