<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Components\PropertyType;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use RealEstates\Model\Entities\PropertyType;
use RealEstates\AdminModule\Model\PropertyTypes;

class PropertyTypeForm extends BaseControl
{
	/** @var PropertyType */
	public $propertyType;

	/** @var PropertyTypes */
	protected $propertyTypesService;

	public function __construct(PropertyTypes $propertyTypes)
	{
		$this->propertyTypesService = $propertyTypes;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addSaveCancelControl();

		$form->addGroup('default.content');
		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addText('singularTitle', 'realEstates.propertyTypeForm.singularTitle')->setRequired()->setMaxLength(255);
		$form->addFilesManager('image', 'default.image');

		$form->addGroup('default.seo');
		$form->addText('seoTitle', 'default.title');
		$form->addTextArea('seoDescription', 'realEstates.propertyTypeForm.description')->setAttribute('rows', 10);

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->propertyType) {
				$propertyType = $this->propertyType;
				$flashMessage = 'realEstates.propertyTypeForm.edited';
			} else {
				$propertyType = new PropertyType($values->title, $values->singularTitle);
				$flashMessage = 'realEstates.propertyTypeForm.added';
			}

			$propertyType->title          = $values->title;
			$propertyType->singularTitle  = $values->singularTitle;
			$propertyType->seoTitle       = $values->seoTitle;
			$propertyType->seoDescription = $values->seoDescription;
			$propertyType->image          = $values->image ?: null;

			$this->em->persist($propertyType)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setPropertyType($id)
	{
		$this->propertyType = $this->propertyTypesService->get($id);

		if ($this->propertyType) {
			$this['form']->setDefaults([
				                           'title'          => $this->propertyType->title,
				                           'singularTitle'  => $this->propertyType->singularTitle,
				                           'seoTitle'       => $this->propertyType->seoTitle,
				                           'seoDescription' => $this->propertyType->seoDescription,
				                           'image'          => $this->propertyType->image,
			                           ]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
