<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Components\PropertyType;

use Core\Model\UI\BaseControl;
use RealEstates\AdminModule\Model\PropertyTypes;

class PropertyTypesGrid extends BaseControl
{
	/** @var PropertyTypes */
	protected $propertyTypesService;

	public function __construct(PropertyTypes $propertyTypes)
	{
		$this->propertyTypesService = $propertyTypes;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		$grid->setRememberState(false);
		$grid->setSortable();
		$grid->setSortableHandler('propertyTypesGrid:gridSortableRow!');

		$qb = $this->propertyTypesService->getEr()->createQueryBuilder('pt')->orderBy('pt.position', 'ASC');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'default.title', 'Settings:editPropertyType');

		// Filter
		$grid->addFilterText('title', '');

		// Actions
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax')->setRenderCondition(function($row) {
			return $row->getId() != 1;
		});

		// Columns prototype

		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->propertyTypesService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * =================  Grid function
	 */

	public function handleGridSortableRow()
	{
		$presenter = $this->getPresenter();
		$request   = $presenter->getHttpRequest();
		$id        = $request->getPost('id', null);
		$position  = $request->getPost('position', null);

		if ($id != null && $position != null && $this->propertyTypesService->getEr()->setPosition($id, $position)) {
			$presenter->flashMessageSuccess('default.positionChanged');
		} else {
			$presenter->flashMessageDanger('default.positionChangeFailed');
		}

		$presenter->redrawControl('flashes');
	}
}
