<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Components\Room;

use Core\Model\UI\BaseControl;
use Nette\Utils\Html;
use RealEstates\AdminModule\Model\Rooms;

class RoomsGrid extends BaseControl
{
	/** @var Rooms */
	protected $roomsService;

	public function __construct(Rooms $rooms)
	{
		$this->roomsService = $rooms;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->roomsService->getEr()->createQueryBuilder('r')->orderBy('r.value', 'ASC');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnText('value', 'default.value')->setRenderer(function($row) {
			return Html::el('a class=ajax', ['href' => $this->getPresenter()->link('roomForm!', [$row->getId()])])->setText($row->value);
		});

		// Filter
		$grid->addFilterText('value', '');

		// Actions
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');

		// Columns prototype

		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		$r         = $this->roomsService->remove($id);
		if (is_string($r)) {
			$presenter->flashMessageInfo($r);
		} else if ($r) {
			$presenter->flashMessageSuccess('default.removed');
		} else {
			$presenter->flashMessageDanger('default.removeFailed');
		}

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * =================  Grid function
	 */
}
