<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Model;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Helpers\BaseEntityService;
use RealEstates\Model\Entities\Author;

/**
 * Class Authors
 * @package RealEstates\AdminModule\Model
 *
 * @method Author|object|null getReference($id)
 * @method Author[]|null getAll()
 * @method Author|null get($id)
 */
class Authors extends BaseEntityService
{
	protected $entityClass = Author::class;

	/**
	 * @param $name
	 *
	 * @return Room|null|object
	 */
	public function getByName($name)
	{
		return $this->getEr()->findOneBy(['name' => $name]);
	}

	/**
	 * Vytvoří nového autora. Pokud existuje vyhodí exception, jinak vrátí autora nebo null
	 *
	 * @param $name
	 *
	 * @return null|Author
	 * @throws InvalidArgumentException
	 */
	public function add($name)
	{
		if ($this->getByName($name)) {
			throw new InvalidArgumentException();
		}

		try {
			$author = new Author($name);
			$this->em->persist($author)->flush();

			return $author;
		} catch (\Exception $e) {
		}

		return null;
	}

	/**
	 * Upraví autora. Pokud existuje vyhodí exception, jinak vrátí autora nebo null
	 *
	 * @param Author $author
	 * @param string $name
	 *
	 * @return null|Author
	 * @throws InvalidArgumentException
	 */
	public function update(Author $author, string $name)
	{
		if ($author->name != $name && $this->getByName($name)) {
			throw new InvalidArgumentException();
		}

		try {
			$author->name = $name;
			$this->em->persist($author)->flush();

			return $author;
		} catch (\Exception $e) {
		}

		return null;
	}

	/**
	 * @param $id
	 *
	 * @return bool|string
	 */
	public function remove($id)
	{
		if ($entity = $this->get($id)) {
			if ($entity->getPropertys()->count()) {
				return 'realEstates.authors.cannotDeleteContainPropertys';
			}

			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}

}