<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Model;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Helpers\BaseEntityService;
use RealEstates\Model\Entities\Filter;

/**
 * Class Filters
 * @package RealEstates\AdminModule\Model
 *
 * @method Filter|object|null getReference($id)
 * @method Filter[]|null getAll()
 * @method Filter|null get($id)
 */
class Filters extends BaseEntityService
{
	protected $entityClass = Filter::class;

	/**
	 * @param $value
	 *
	 * @return Filter|null|object
	 */
	public function getByValue($value)
	{
		return $this->getEr()->findOneBy(['value' => $value]);
	}

	/**
	 * @param $value
	 *
	 * @return null|Filter
	 * @throws InvalidArgumentException
	 */
	public function add($value)
	{
		if ($this->getByValue($value)) {
			throw new InvalidArgumentException();
		}

		try {
			$filter = new Filter($value);
			$this->em->persist($filter)->flush();

			return $filter;
		} catch (\Exception $e) {
		}

		return null;
	}

	/**
	 * @param Filter $filter
	 * @param string $value
	 *
	 * @return null|Filter
	 * @throws InvalidArgumentException
	 */
	public function update(Filter $filter, string $value)
	{
		if ($filter->value != $value && $this->getByValue($value)) {
			throw new InvalidArgumentException();
		}

		try {
			$filter->value = $value;
			$this->em->persist($filter)->flush();

			return $filter;
		} catch (\Exception $e) {
		}

		return null;
	}

	/**
	 * @param $id
	 *
	 * @return bool|string
	 * @throws \Exception
	 */
	public function remove($id)
	{
		if ($entity = $this->get($id)) {
			if ($entity->getPropertys()->count()) {
				return 'realEstates.filters.cannotDeleteContainPropertys';
			}

			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}

}