<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use RealEstates\Model\Entities\Param;

/**
 * Class Params
 * @package RealEstates\AdminModule\Model
 *
 * @method Param|object|null getReference($id)
 * @method Param[]|null getAll()
 * @method Param|null get($id)
 */
class Params extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Param::class;

	/** @var Settings */
	protected $settings;

	public function __construct(Settings $settings)
	{
		$this->settings = $settings;
	}

	/**
	 * @param $pattern
	 * @param $pricePerUnit
	 *
	 * @return string
	 */
	public function preparePattern($pattern, $pricePerUnit)
	{
		$pattern = $pattern . '*' . ($this->settings->get('priceModify') ?: 1);
		$pattern = str_replace('$ppu', $pricePerUnit, $pattern);

		return $pattern;
	}
}