<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Model;

use Core\Model\Entities\Repository\SortableRepository;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use RealEstates\Model\Entities\PropertyType;

/**
 * Class PropertyTypes
 * @package RealEstates\AdminModule\Model
 *
 * @method PropertyType|object|null getReference($id)
 * @method PropertyType[]|null getAll()
 * @method PropertyType|null get($id)
 * @method SortableRepository getEr()
 */
class PropertyTypes extends BaseEntityService
{
	use TPublish;

	protected $entityClass = PropertyType::class;

	public function remove($id)
	{
		if ($id == 1)
			return false;

		return parent::remove($id);
	}
}