<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Model;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Helpers\BaseEntityService;
use Nette\Neon\Neon;
use RealEstates\Model\Entities\Setting;

/**
 * Class Settings
 * @package RealEstates\AdminModule\Model
 */
class Settings extends BaseEntityService
{
	/** @var array */
	protected $data;

	/** @var string */
	protected $entityClass = Setting::class;

	/** @var string */
	protected $neonFile = CUSTOM_DIR . '/RealEstates/config/settings.neon';

	public function setData($key, $value)
	{
		try {
			$this->getEr()->createQueryBuilder('s')->update()->set('s.value', ':value')->setParameter('value', $value)
				->where('s.key = :key')->setParameter('key', $key)
				->getQuery()->execute();

			return true;
		} catch (\Exception $e) {
		}

		return false;
	}

	public function get($key)
	{
		if (isset($this->getData()[$key])) {
			$v = $this->getData()[$key];
			settype($v['value'], $v['type']);

			return $v['value'];
		}

		if ($v = $this->getEr()->findOneBy(['key' => $key])) {
			return $v->value;
		}

		return null;
	}

	/**
	 * Načtení konfingu ze souboru
	 *
	 * @return array
	 */
	public function getData()
	{
		if (!$this->data) {
			$content = @file_get_contents($this->neonFile);
			if ($content) {
				$this->data = Neon::decode($content);
			}
		}

		return $this->data;
	}

	/**
	 * Aktualizace neon nastavení
	 *
	 * @param $arr
	 *
	 * @return bool
	 */
	public function updateData($arr)
	{
		$neonData = $this->getData();
		$data     = [];
		foreach ($arr as $k => $v) {
			$data[$k] = [
				'type'  => $neonData[$k]['type'] ?? 'text',
				'value' => $v,
			];
		}

		$data = array_replace_recursive($neonData, $data);

		try {
			if (!$data) {
				throw new InvalidArgumentException();
			}

			$this->data = $data;
			file_put_contents($this->neonFile, Neon::encode($data, Neon::BLOCK));
		} catch (\Exception $e) {
			return false;
		}

		return true;
	}
}
