<?php declare(strict_types = 1);

namespace RealEstates\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use RealEstates\AdminModule\Components\Property\IPropertyFormFactory;
use RealEstates\AdminModule\Components\Property\IPropertysGridFactory;
use RealEstates\Model\Entities\Property;

class OfflinePresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this->setHeader('realEstates.title.offlineHouses', 'fas fa-toggle-off');
		$this->setTitle($this->translator->translate('realEstates.title.offlineHouses'));
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'realEstates.menu.addProperty',
				'link'  => 'Offline:addProperty',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddProperty()
	{
		$this->setHeader('realEstates.title.addProperty', 'fas fa-toggle-off');
		$this->setTitle($this->translator->translate('realEstates.title.addProperty'));
	}

	public function actionEditProperty($id)
	{
		$property = $this->em->getRepository(Property::class)->find($id);

		if (!$property)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setHeader('realEstates.title.editProperty', 'fas fa-toggle-off');
		$this->setTitle($this->translator->translate('realEstates.title.editProperty'), $property->title);
	}

	/*******************************************************************************************************************
	 * ============================== Handle
	 */

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentPropertysGrid(IPropertysGridFactory $factory)
	{
		$control = $factory->create();

		$control->calculationRegenerate = true;

		$qb = $control->getQb();
		$qb->andWhere('p.isOffline = 1');
		$control->setQb($qb);

		return $control;
	}

	protected function createComponentPropertyForm(IPropertyFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setProperty($this->getParameter('id'));

		$control['form']->removeComponent($control['form']['regenerateCalculation']);
		$control['form']->removeComponent($control['form']['regenerateCatalog']);

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('Offline:editProperty', $form->getCustomData('propertyId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('Offline:default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('Offline:default');;
		};

		return $control;
	}
}
