<?php declare(strict_types = 1);

namespace RealEstates\FrontModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\Common\Collections\Criteria;
use Gedmo\Sortable\Entity\Repository\SortableRepository;
use RealEstates\Model\Entities\Param;
use RealEstates\Model\Entities\PropertyParam;
use RealEstates\Model\Helpers\Calculator;
use RealEstates\FrontModule\Model\Dao;

/**
 * Class Params
 * @package RealEstates\FrontModule\Model
 *
 * @method Param|object|null getReference($id)
 * @method Param[]|null getAll()
 * @method Param|null get($id)
 * @method SortableRepository getEr()
 */
class Params extends BaseEntityService
{
	protected $entityClass = Param::class;

	/** @var Calculator */
	protected $calculator;

	public function __construct(Calculator $calculator)
	{
		$this->calculator = $calculator;
	}

	public function getErPropertyParam()
	{
		return $this->em->getRepository(PropertyParam::class);
	}

	/**
	 * @return Criteria
	 */
	protected function publishedCriteria()
	{
		$expr     = Criteria::expr();
		$criteria = Criteria::create()
			->andWhere(
				$expr->eq('p.isPublished', 1)
			);

		return $criteria;
	}

	/**
	 * @param null|int|array $id
	 *
	 * @return Dao\Param[]
	 * @throws \Doctrine\ORM\Query\QueryException
	 */
	public function getPublished($id = null)
	{
		$params    = [];
		$paramsRaw = $this->getEr()->createQueryBuilder('p')->addCriteria($this->publishedCriteria());

		if ($id)
			$paramsRaw->andWhere(is_array($id) ? 'p.id IN (:id)' : 'p.id = :id')->setParameter('id', $id);
		$paramsRaw = $paramsRaw->getQuery()->getArrayResult();

		foreach ($paramsRaw as $p) {
			$param            = (new Dao\Param())
				->setId($p['id'])
				->setTitle($p['title'])
				->setDescription($p['description'])
				->setPricePerUnit($p['pricePerUnit'])
				->setUnit($p['unit']);
			$params[$p['id']] = $param;
		}

		return $params;
	}
}
