<?php declare(strict_types = 1);

namespace RealEstates\FrontModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\Common\Collections\Criteria;
use Doctrine\ORM\Query;
use RealEstates\Model\Entities\Room;

/**
 * Class Rooms
 * @package RealEstates\FrontModule\Model
 *
 * @method Room|object|null getReference($id)
 * @method Room[]|null getAll()
 * @method Room|null get($id)
 */
class Rooms extends BaseEntityService
{
	protected $entityClass = Room::class;

	/**
	 * @return Criteria
	 */
	protected function publishedCriteria()
	{
		$expr     = Criteria::expr();
		$criteria = Criteria::create();

		return $criteria;
	}

	/**
	 * @param int|array|null $id
	 *
	 * @return array|mixed
	 * @throws Query\QueryException
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function getPublished($id = null)
	{
		$rooms = $this->getEr()->createQueryBuilder('p', 'p.id')->addCriteria($this->publishedCriteria());

		if ($id)
			$rooms->andWhere(is_array($id) ? 'p.id IN (:id)' : 'p.id = :id')->setParameter('id', $id);

		$rooms = $rooms->getQuery();

		if (is_numeric($id))
			return $rooms->getOneOrNullResult(Query::HYDRATE_ARRAY);

		return $rooms->getArrayResult();
	}

	/**
	 * @param string $value
	 *
	 * @return array|null
	 * @throws Query\QueryException
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function getByValue($value)
	{
		$rooms = $this->getEr()->createQueryBuilder('r')->addCriteria($this->publishedCriteria())
			->andWhere('r.value = :value')->setParameter('value', $value);

		return $rooms->getQuery()->getOneOrNullResult(Query::HYDRATE_ARRAY);
	}
}
