<?php declare(strict_types = 1);

namespace RealEstates\FrontModule\Presenters;

use Pages\Model\Entities\TemplatePage;
use Pages\Model\Paths;
use RealEstates\FrontModule\Components\IPropertysFilterFactory;
use RealEstates\FrontModule\Model\Propertys;
use RealEstates\FrontModule\Components\IPropertysListFactory;
use Pages\FrontModule\Model\TemplatePages;
use RealEstates\Model\Entities\Property;
use RealEstates\Model\PropertysPdf;
use RealEstates\Model\Settings;

class DefaultPresenter extends BasePresenter
{
	/** @var Propertys */
	protected $propertysService;

	/** @var TemplatePages */
	protected $templatePagesService;

	/** @var TemplatePage */
	protected $templatePage;

	/** @var PropertysPdf */
	protected $propertysPdf;

	/** @var Paths */
	protected $pathsService;

	/** @var Property */
	protected $property;

	/** @var Settings */
	protected $settings;

	public function __construct(Propertys $propertys, TemplatePages $templatePages, PropertysPdf $propertysPdf, Paths $paths, Settings $settings)
	{
		$this->propertysService     = $propertys;
		$this->templatePagesService = $templatePages;
		$this->propertysPdf         = $propertysPdf;
		$this->pathsService         = $paths;
		$this->settings             = $settings;
	}

	/*******************************************************************************************************************
	 * ============================== Handle
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this->template->pageClass .= ' page-realestates';

		$templatePage       = $this->templatePagesService->get($this->getActiveNavigation()->componentParams['templatePage']);
		$this->templatePage = $templatePage;

		$this->template->templateTextValues = $templatePage->getTexts();
		$this->template->setFile($this->pathsService->getTemplatePagesFile($templatePage->template));
	}

	public function actionDetail($id)
	{
		/** @var \RealEstates\FrontModule\Model\Dao\Property $property */
		$property = $this->propertysService->getPublished($id);

		if (!$property)
			$this->error('pages.page.notFound');

		$this->setTitle($property->title);
		$this->template->pageClass .= ' page-realestates';
		$this->template->property  = $property;
		$this->property            = $property;

		$this->seoDataFromEntity  = $property->getSeo();
		$this->template->backLink = $this->navigationsService->generateLink($this->getActiveNavigation());
	}

	/*******************************************************************************************************************
	 * ============================== Render
	 */

	public function renderDetail($id)
	{
		$this->propertysService->addView($id);
	}

	/*******************************************************************************************************************
	 * ============================== Render
	 */

	public function renderDefault()
	{
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentPropertysList(IPropertysListFactory $factory)
	{
		$control = $factory->create();
		$control->setPropertysFilterControl($this['propertysFilter']);

		return $control;
	}

	protected function createComponentPropertysFilter(IPropertysFilterFactory $factory)
	{
		$control             = $factory->create();
		$control->onAnchor[] = function() use ($control) {
			if ($this->templatePage)
				$control->template->texts = $this->templatePage->getTexts();
		};

		return $control;
	}
}
