<?php declare(strict_types = 1);

namespace RealEstates\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="real_estates__author")
 * @ORM\Entity
 * @ORM\EntityListeners({"RealEstateListener"})
 */
class Author
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255, nullable=false, unique=true)
	 */
	public $name;

	/**
	 * @var Property[]
	 * @ORM\OneToMany(targetEntity="Property", mappedBy="author")
	 */
	private $propertys;

	/**
	 * Author constructor.
	 *
	 * @param $name
	 */
	public function __construct($name)
	{
		$this->name      = $name;
		$this->propertys = new ArrayCollection();
	}

	/**
	 * @return Property[]|ArrayCollection
	 */
	public function getPropertys() { return $this->propertys; }
}
