<?php declare(strict_types = 1);

namespace RealEstates\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="real_estates__filter")
 * @ORM\Entity
 * @ORM\EntityListeners({"RealEstateListener"})
 */
class Filter
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255, nullable=false, unique=true)
	 */
	public $value;

	/**
	 * @var Property[]
	 * @ORM\ManyToMany(targetEntity="Property", mappedBy="filters")
	 */
	private $propertys;

	/**
	 * Filter constructor.
	 *
	 * @param string $value
	 */
	public function __construct($value)
	{
		$this->value     = $value;
		$this->propertys = new ArrayCollection();
	}

	/**
	 * @return Property[]|ArrayCollection
	 */
	public function getPropertys() { return $this->propertys; }
}
