<?php declare(strict_types = 1);

namespace RealEstates\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="real_estates__param")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 * @ORM\EntityListeners({"RealEstateListener"})
 */
class Param
{
	use Identifier;
	use MagicAccessors;

	const PATTERN = '$v * $ppu';

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="text", nullable=true)
	 */
	public $description;

	/**
	 * @var string
	 * @ORM\Column(name="description2", type="text", nullable=true)
	 */
	public $description2;

	/**
	 * @var int
	 * @ORM\Column(name="price_per_unit", type="integer", nullable=false, options={"default":0})
	 */
	public $pricePerUnit;

	/**
	 * @var string
	 * @ORM\Column(name="unit", type="string", length=20, nullable=true)
	 */
	public $unit;

	/**
	 * @var string
	 * @ORM\Column(name="pattern", type="string", nullable=true)
	 */
	protected $pattern;

	/**
	 * @var PropertyParam[]
	 * @ORM\OneToMany(targetEntity="PropertyParam", mappedBy="params")
	 */
	private $params;

	/**
	 * @var VariantParam[]
	 * @ORM\OneToMany(targetEntity="VariantParam", mappedBy="param")
	 */
	private $variants;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	private $position;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1})
	 */
	public $isPublished;

	/**
	 * @var string
	 * @ORM\Column(name="use_value_from_property", type="string", length=120, nullable=true)
	 */
	public $useValueFromProperty;

	/**
	 * PropertyType constructor.
	 *
	 * @param $title
	 */
	public function __construct($title)
	{
		$this->title        = $title;
		$this->pricePerUnit = 0;
		$this->params       = new ArrayCollection();
		$this->variants     = new ArrayCollection();
		$this->pattern      = self::PATTERN;
		$this->isPublished  = 1;
		$this->setPosition(-1);
	}

	/******
	 * === Pattern
	 */

	public function getPattern() { return $this->pattern ?: self::PATTERN; }

	public function setPattern($pattern) { $this->pattern = $pattern; }

	/******
	 * === Position
	 */

	public function setPosition($position)
	{
		$this->position = $position;
	}

	public function getPosition()
	{
		return $this->position;
	}
}
