<?php declare(strict_types = 1);

namespace RealEstates\Model\Entities;

use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="real_estates__property_type")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 * @ORM\EntityListeners({"RealEstateListener"})
 */
class PropertyType
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="singular_title", type="string", length=255, nullable=false)
	 */
	public $singularTitle;

	/**
	 * @var string
	 * @ORM\Column(name="image", type="string", length=255, nullable=true)
	 */
	public $image;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	private $position;

	/**
	 * @var array
	 * @ORM\Column(name="params", type="array", nullable=true)
	 */
	protected $params;

	/**
	 * @var string
	 * @ORM\Column(name="seo_title", type="string", length=255, nullable=true)
	 */
	public $seoTitle;

	/**
	 * @var string
	 * @ORM\Column(name="seo_description", type="text", nullable=true)
	 */
	public $seoDescription;

	/**
	 * PropertyType constructor.
	 *
	 * @param $title
	 */
	public function __construct($title, $singularTitle)
	{
		$this->title         = $title;
		$this->singularTitle = $singularTitle;
		$this->params        = [];
		$this->setPosition(-1);
	}

	/******
	 * === Position
	 */

	public function setPosition($position)
	{
		$this->position = $position;
	}

	public function getPosition()
	{
		return $this->position;
	}

	/*****
	 * === Params
	 */

	public function getParams() { return $this->params ?: []; }

	public function getParam($key) { return $this->params[$key] ?? null; }

	public function setParam($key, $value)
	{
		if ($value == null) {
			unset($this->params[$key]);
		} else {
			$this->params[$key] = $value;
		}
	}
}
