<?php declare(strict_types = 1);

namespace RealEstates\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Http\Session;
use Nette\SmartObject;
use RealEstates\FrontModule\Model\Propertys;

class RealEstateListener implements Subscriber
{
	use SmartObject;

	/** @var Cache */
	private $cache;

	/** @var Session */
	private $session;

	/** @var Cache */
	protected $navigationCache;

	protected $fields = false;

	protected static $cleared = false;

	public function __construct(IStorage $cacheStorage, Session $session)
	{
		$this->session         = $session;
		$this->cache           = new Cache($cacheStorage, Propertys::CACHE_NAMESPACE);
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param \stdClass          $entity
	 * @param LifecycleEventArgs $event
	 */
	public function postHandler($entity, LifecycleEventArgs $event)
	{
		if ($entity instanceof Property && $entity->isOffline || self::$cleared)
			return;

		$this->clearCache();

		self::$cleared = true;
	}

	public function clearCache()
	{
		$this->cache->clean([
			Cache::TAGS => [Propertys::CACHE_NAMESPACE],
		]);
		$this->navigationCache->clean([
			Cache::TAGS => [Navigations::CACHE_NAMESPACE],
		]);

		self::$cleared = true;
	}
}
