<?php declare(strict_types = 1);

namespace RealEstates\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="real_estates__setting")
 * @ORM\Entity
 * @ORM\EntityListeners({"RealEstateListener"})
 */
class Setting
{
	use MagicAccessors;

	/**
	 * @var integer
	 * @ORM\Id
	 * @ORM\Column(name="`key`", type="string")
	 */
	private $key;

	/**
	 * @var string
	 * @ORM\Column(name="value", type="string", length=255, nullable=true)
	 */
	public $value;

	public function __construct($key, $value)
	{
		$this->setKey($key);
		$this->value = $value;
	}

	public function getKey() { return $this->key; }

	public function setKey($key) { $this->key = $key; }

	public function __clone()
	{
		$this->key = null;
	}
}
