<?php declare(strict_types = 1);

namespace RealEstates\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="real_estates__variant")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 * @ORM\EntityListeners({"RealEstateListener"})
 */
class Variant
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var VariantParam[]
	 * @ORM\OneToMany(targetEntity="VariantParam", mappedBy="variant")
	 */
	private $params;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	private $position;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1})
	 */
	public $isPublished;

	/**
	 * Variant constructor.
	 *
	 * @param $title
	 */
	public function __construct($title)
	{
		$this->title = $title;
		$this->setPosition(-1);
		$this->isPublished = 1;
		$this->params      = new ArrayCollection();
	}

	/******
	 * === Position
	 */

	public function getPosition() { return $this->position; }

	public function setPosition($position)
	{
		$this->position = $position;
	}

	/******
	 * === Params
	 */

	public function getParams() { return $this->params; }

	public function addParam($param)
	{
		if (!$this->params->contains($param)) {
			$this->params->add($param);
		}
	}
}
