<?php declare(strict_types = 1);

namespace RealEstates\Model\TemplateTextType;

use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use Nette\InvalidArgumentException;
use RealEstates\FrontModule\Model\Propertys;

class PropertysOnline extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'realEstatesPropertysOnline';

	/** @var Propertys */
	protected $propertysService;

	/**
	 * RealEstatesOnline constructor.
	 *
	 * @param Propertys $propertys
	 */
	public function __construct(Propertys $propertys)
	{
		$this->propertysService = $propertys;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$orderBy = [
			'p.publishUp DESC' => 'realEstates.orderBy.publishUp',
			'p.views DESC'     => 'realEstates.orderBy.views',
		];

		$container = new BaseContainer();
		$container->addText('limit', 'realEstates.templateTextType.count')->setType('number')
			->setAttribute('step', '1')->setDefaultValue(8);
		$container->addSelect('orderBy', 'realEstates.templateTextType.orderBy', $orderBy);

		$formContainer->addComponent($container, $this->getName());
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->getDefault() ? $this->propertysService->getPublished(null, $this->getDefault()['orderBy'], (int) $this->getDefault()['limit']) : null;
	}
}
