<?php declare(strict_types = 1);

namespace References\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use References\AdminModule\Components\IGeneralFormFactory;
use References\AdminModule\Components\IGeneralGroupFormFactory;
use References\AdminModule\Components\IGeneralGroupsGridFactory;
use References\AdminModule\Components\IGeneralsGridFactory;
use References\Model\Entities\GeneralGroup;
use References\Model\Entities\General;

final class GeneralPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('references.title.generalReferences'));
		$this->setHeader('references.title.generalReferences', 'fas fa-user-alt');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'references.menu.addReference',
				'link'  => 'General:addReference',
				'ico'   => 'plus',
			], [
				'title' => 'references.menu.addGroup',
				'link'  => 'General:addGroup',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddGroup()
	{
		$this->setTitle($this->translator->translate('references.title.addGroup'));
		$this->setHeader('references.title.addGroup', 'fas fa-user-alt');
	}

	public function actionAddReference()
	{
		$this->setTitle($this->translator->translate('references.title.addReference'));
		$this->setHeader('references.title.addReference', 'fas fa-user-alt');
	}

	public function actionEditGroup($id)
	{
		$group = $this->em->getRepository(GeneralGroup::class)->find($id);

		if (!$group)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('references.title.editGroup'), $group->title);
		$this->setHeader('references.title.editGroup', 'fas fa-user-alt');
	}

	public function actionEditReference($id)
	{
		$reference = $this->em->getRepository(General::class)->find($id);

		if (!$reference)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('references.title.editReference'), $reference->title);
		$this->setHeader('references.title.editReference', 'fas fa-user-alt');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentGeneralGroupsGrid(IGeneralGroupsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentGeneralGroupForm(IGeneralGroupFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setGroup($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentGeneralsGrid(IGeneralsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentGeneralForm(IGeneralFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setReference($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editReference', $form->getCustomData('referenceId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}
}