<?php declare(strict_types = 1);

namespace References\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

class GeneralReference
{
	use MagicAccessors {
		__get as MA__get;
	}

	/** @var int */
	protected $id;

	/** @var string */
	protected $title;

	/** @var string */
	protected $image;

	/** @var string */
	protected $introtext;

	/** @var int */
	protected $isFeatured;

	/** @var Group */
	protected $group;

	/** @var array */
	protected $params;

	public function setId($id)
	{
		$this->id = $id;

		return $this;
	}

	public function setTitle($title)
	{
		$this->title = $title;

		return $this;
	}

	public function setImage($image)
	{
		$this->image = $image;

		return $this;
	}

	public function setIntrotext($introtext)
	{
		$this->introtext = $introtext;

		return $this;
	}

	public function setIsFeatured($isFeatured) {
		$this->isFeatured = $isFeatured;

		return $this;
	}

	public function setGroup(Group $group)
	{
		$this->group = $group;

		return $this;
	}

	public function setParams(array $params)
	{
		$this->params = $params;

		return $this;
	}

	public function &__get($name)
	{
		if (isset($this->params[$name]))
			return $this->params[$name];

		try {
			return $this->MA__get($name);
		} catch (\Exception $e) {

		}

		return null;
	}

}