<?php declare(strict_types = 1);

namespace References\FrontModule\Presenters;

use References\FrontModule\Model\GeneralGroups;
use References\FrontModule\Model\GeneralReferences as FrontGeneralReferences;
use References\Model\GeneralReferences;

class GeneralPresenter extends BasePresenter
{
	/** @var GeneralReferences */
	protected $generalReferences;
	/** @var FrontGeneralReferences */
	protected $frontGeneralReferences;

	/** @var GeneralGroups */
	protected $generalGroups;

	public function __construct(FrontGeneralReferences $frontGeneralReferences, GeneralReferences $generalReferences, GeneralGroups $generalGroups)
	{
		$this->frontGeneralReferences = $generalReferences;
		$this->generalReferences      = $generalReferences;
		$this->generalGroups          = $generalGroups;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this->template->pageClass  .= ' page-references';
		$this->template->references = $this->frontGeneralReferences->getAll();
		$this->template->groups     = $this->generalGroups->getTree();
	}

	public function actionDetail($id)
	{
		$reference = $this->generalReferences->get($id);

		if (!$reference)
			$this->error('references.reference.notFound');

		$this->template->pageClass          .= ' page-references-detail';
		$this->template->backLink           = $this->navigationsService->generateLink($this->getActiveNavigation());
		$this->template->reference          = $reference;
		$this->template->templateTextValues = $reference->getTexts();
		$this->template->setFile($this->generalReferences->getTemplateFile($reference->template));
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	//	protected function createComponentPropertysList(IPropertysListFactory $factory)
	//	{
	//		$control = $factory->create();
	//
	//		return $control;
	//	}
}