<?php declare(strict_types=1);

namespace References\Model\Entities;

use Core\Model\Entities\TLang;
use Core\Model\TemplateReader\Entity\TTemplate;
use Core\Model\TemplateReader\Entity\ITemplate;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use References\Model\Entities\GeneralGroup;

/**
 * @ORM\Table(name="references__general")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class General implements ITemplate
{
	use Identifier;
	use MagicAccessors;
	use TTemplate;
	use TLang;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="image", type="string", nullable=true, length=255)
	 */
	public $image;

	/**
	 * @var string
	 * @ORM\Column(name="introtext", type="string", nullable=true, length=255)
	 */
	public $introtext;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", nullable=false)
	 */
	public $isPublished;

	/**
	 * @var int
	 * @ORM\Column(name="is_featured", type="smallint", nullable=false)
	 */
	public $isFeatured;

	/**
	 * @var int
	 *
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	public $position;

	/**
	 * @var GeneralGroup
	 *
	 * @ORM\ManyToOne(targetEntity="GeneralGroup", inversedBy="references")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", nullable=true)
	 */
	public $group;

	/**
	 * TemplatePage constructor.
	 *
	 * @param $title
	 * @param $template
	 */
	public function __construct($title, $template)
	{
		$this->title = $title;
		$this->template = $template;
		$this->isPublished = 1;
		$this->isFeatured = 0;
		$this->texts = [];
		$this->setPosition(-1);
	}

	public function setPosition($position) {
		$this->position = intval($position);
	}
}