<?php declare(strict_types = 1);

namespace References\Model\Navigation;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Nette\Utils\Strings;
use References\FrontModule\Model\GeneralReferences;

class General extends BaseNavigation implements INavigationItem
{
	protected $title           = 'general';
	protected $presenter       = 'References:Front:General';
	protected $action          = 'default';
	protected $presenterDetail = 'References:Front:General';
	protected $actionDetail    = 'detail';

	/** @var GeneralReferences */
	protected $generalReferences;

	public function __construct(GeneralReferences $generalReferences)
	{
		$this->generalReferences = $generalReferences;
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;
		if ($this->presenterDetail == $presenter && $this->actionDetail == $action)
			return 2;

		return false;
	}

	public function routerIn($params, $urlParams = [])
	{
		if (isset($urlParams['path'])) {
			$params = explode('/', $urlParams['path']);
			$id     = explode('-', array_pop($params), 2);

			if (is_numeric($id[0])) {
				return [
					'presenter' => $this->presenterDetail,
					'action'    => $this->actionDetail,
					'id'        => $id[0],
				];
			}
		}

		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut($navigation, &$urlParams)
	{
		if ($navigation instanceof Navigation == false)
			return false;

		if (isset($urlParams['id'])) {
			$reference = $this->generalReferences->get($urlParams['id']);
			if ($reference)
				return ($navigation->isHomepage ? '' : '/' . $navigation->alias) . '/' . $reference->getId() . '-' . Strings::webalize($reference->title);
		}

		return $navigation->isHomepage ? '' : '/' . $navigation->alias;
	}
}