<?php declare(strict_types = 1);

namespace References\Model;

use Core\Model\Helpers\Arrays;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Core\Model\Entities\Repository\NestedTreeRepository;
use References\Model\Entities\GeneralGroup;

/**
 * Class GeneralGroups
 * @package References\Model
 *
 * @method GeneralGroup|object|null getReference($id)
 * @method GeneralGroup[]|null getAll()
 * @method GeneralGroup|null get($id)
 * @method NestedTreeRepository getEr()
 */
class GeneralGroups extends BaseEntityService
{
	use TPublish;

	protected $entityClass = GeneralGroup::class;
}