<?php declare(strict_types = 1);

namespace References\Model\Navigation;

use Core\Model\Dao\SiteMapUrl;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Nette\Utils\Strings;
use References\FrontModule\Model\GeneralReferences;
use References\Model\ConfigOptions;

class General extends BaseNavigation implements INavigationItem
{
	protected $title           = 'general';
	protected $presenter       = 'References:Front:General';
	protected $action          = 'default';
	protected $presenterDetail = 'References:Front:General';
	protected $actionDetail    = 'detail';

	/** @var ConfigOptions */
	protected $configOptions;

	/** @var GeneralReferences */
	protected $generalReferences;

	public function __construct(ConfigOptions $configOptions, GeneralReferences $generalReferences)
	{
		$this->configOptions     = $configOptions;
		$this->generalReferences = $generalReferences;
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;
		if ($this->presenterDetail == $presenter && $this->actionDetail == $action)
			return 2;

		return false;
	}

	public function routerIn($navigation, $urlParams = [])
	{
		if ($navigation->alias != $urlParams['path'] && isset($urlParams['path'])) {
			$params = explode('/', $urlParams['path']);
			$id     = explode('-', end($params), 2);

			$return = [
				'presenter' => $this->presenterDetail,
				'action'    => $this->actionDetail,
			];

			if (!is_numeric($id[0])) {
				$referenceId = $this->generalReferences->getPublishedIdByAlias(end($params));

				if ($referenceId)
					$return['id'] = $referenceId;
			} else {
				$return['id'] = $id[0];
			}

			if (isset($return['id']))
				return $return;
		}

		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut($navigation, &$urlParams)
	{
		if ($navigation instanceof Navigation == false)
			return false;

		if (isset($urlParams['id'])) {
			$reference = $this->generalReferences->get($urlParams['id']);
			if ($reference) {
				$referenceUrl = $reference->alias;

				if (!$this->configOptions->get('removeReferenceIdFromUrl'))
					$referenceUrl = $reference->getId() . '-' . $referenceUrl;

				return ($navigation->isHomepage ? '' : '/' . $navigation->alias) . '/' . $referenceUrl;
			}
		}

		return $navigation->isHomepage ? '' : '/' . $navigation->alias;
	}

	public function getComponentChild($navigation = null, $siteMapData = false)
	{
		$arr = [];

		foreach ($this->generalReferences->getAll() as $ref) {
			$data = [
				'action'    => $this->actionDetail,
				'id'        => $ref->getId(),
				'presenter' => $this->presenterDetail,
			];

			if ($siteMapData) {
				$siteMapUrl = new SiteMapUrl();
				if ($ref->getModified())
					$siteMapUrl->setModified($ref->getModified());
				$siteMapUrl->setSeo($ref->getSeo());

				$data['siteMapData']['default'] = $siteMapUrl;
			}

			if ($navigation)
				$data['activeNavigation'] = $navigation;

			$arr[] = $data;
		}

		return $arr;
	}
}
