<?php declare(strict_types = 1);

namespace References\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use References\Model\Entities\GeneralGroup;
use References\Model\GeneralGroups;

class GeneralGroupForm extends BaseControl
{
	/** @var GeneralGroup */
	public $group;

	/** @var GeneralGroups */
	protected $groupsService;

	public function __construct(GeneralGroups $groups)
	{
		$this->groupsService = $groups;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$groups = [null => ''];
		foreach ($this->groupsService->getEr()->createQueryBuilder('g')->select('g.id, g.title, g.lvl')
			         ->orderBy('g.root')->addOrderBy('g.lft')->getQuery()->getArrayResult() as $v) {
			if ($this->group && $this->group->getId() == $v['id'])
				continue;

			$title = ' ' . $v['title'];
			for ($i = 0; $i < $v['lvl']; $i++)
				$title = '---' . $title;
			$groups[$v['id']] = $title;
		}

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addSelect('parent', 'default.parent', $groups);
		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->group) {
				$group        = $this->group;
				$flashMessage = 'references.groupForm.edited';
			} else {
				$group        = new GeneralGroup($values->title);
				$flashMessage = 'references.groupForm.added';
			}

			$group->title       = $values->title;
			$group->isPublished = $values->isPublished;

			if ($values->parent == '') {
				$group->setParent(null);
			} else {
				$group->setParent($this->groupsService->get($values->parent));
			}

			$this->em->persist($group)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	/*******************************************************************************************************************
	 * ==================  GET / SET
	 */

	public function setGroup($id)
	{
		$this->group = $this->groupsService->get($id);

		if ($this->group) {
			$this['form']->setDefaults([
				'title'       => $this->group->title,
				'isPublished' => $this->group->isPublished,
			]);

			if ($this->group->parent && array_key_exists($this->group->parent->getId(), $this['form']['parent']->getItems())) {
				$this['form']['parent']->setDefaultValue($this->group->parent->getId());
			}
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}

}
