<?php declare(strict_types = 1);

namespace References\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use References\Model\GeneralGroups;
use References\FrontModule\Model\GeneralReferences;

class GeneralGroup extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'generalRefByGroup';

	/** @var GeneralReferences */
	protected $referencesService;

	/** @var GeneralGroups */
	protected $groupsService;

	public function __construct(GeneralReferences $references, GeneralGroups $groups)
	{
		$this->referencesService = $references;
		$this->groupsService     = $groups;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$groups = [];
		foreach ($this->groupsService->getEr()->findBy([], ['title' => 'ASC']) as $g) {
			$groups[$g->getId()] = $g->title;
		}

		$formContainer->addSortableCheckboxList($this->getName(), $this->getTitle(), $groups);
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->referencesService->getPublishedByGroup($this->getDefault(), $params['limit'] ?? null, $params['featuredOnly'] ?? null, $params['groupBy'] ?? null);
	}
}
