<?php declare(strict_types = 1);

namespace References\FrontModule\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use Core\Model\Event\TtSearchEvent;
use Kdyby\Doctrine\EntityManager;
use References\FrontModule\Model\GeneralReferences;
use Teams\Model\Members;

class TtSearchSubscriber implements EventSubscriber
{
	/** @var EntityManager */
	protected $em;

	/** @var GeneralReferences */
	protected $generalRefenreces;

	public function __construct(EntityManager $em, GeneralReferences $generalReferences)
	{
		$this->em                = $em;
		$this->generalRefenreces = $generalReferences;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'core.searching.deep' => 'search',
		];
	}

	public function search(TtSearchEvent $event): void
	{
		$result   = [];
		$groupIds = [];
		foreach ($event->inputs as $row) {
			if (in_array($row['type'], ['generalRefByGroup'])) {
				$ids = $event->values[$row['name']];
				foreach ($ids as $id)
					$groupIds[$id] = $id;
			}
		}

		if (empty($groupIds))
			return;


		$qb = $this->generalRefenreces->getEr()->createQueryBuilder('gr')
			->select('IDENTITY(gr.group) as group, gr.id, gr.title, gr.introtext, gr.texts')
			->where('gr.group IN (:groups)')->andWhere('gr.isPublished = 1')
			->setParameter('groups', array_values($groupIds));

		$q = $event->q;
		$qb->andWhere('gr.title LIKE :q OR gr.texts LIKE :q')
			->setParameter('q', "%$q%");
		//		$k = 0;
		//		foreach (explode(' ', $event->q) as $k => $q) {
		//		$qb->orWhere("gr.title LIKE :q$k OR gr.texts LIKE :q$k")
		//			->setParameter("q$k", "%$q%");
		//		}

		foreach ($qb->getQuery()->getArrayResult() as $row) {
			$result[$row['group']][$row['id']] = [
				'title' => $row['title'],
				'texts' => $row['texts'],
			];
		}

		if (!empty($result))
			$event->addResult('generalRefByGroup', $result);
	}
}
