<?php declare(strict_types = 1);

namespace References\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use References\Model\Entities\General;

/**
 * @Gedmo\Tree(type="nested")
 * @ORM\Table(name="references__general_group")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\NestedTreeRepository")
 */
class GeneralGroup
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public $title;

	/**
	 * @var General[]
	 *
	 * @ORM\OneToMany(targetEntity="General", mappedBy="group")
	 */
	protected $references;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1})
	 */
	public $isPublished;

	/**
	 * @var GeneralGroup[]
	 * @ORM\OneToMany(targetEntity="GeneralGroup", mappedBy="parent")
	 * @ORM\OrderBy({"lft" = "ASC"})
	 */
	private $children;

	/**
	 * @var GeneralGroup
	 * @Gedmo\TreeParent
	 * @ORM\ManyToOne(targetEntity="GeneralGroup", inversedBy="childrens")
	 * @ORM\JoinColumn(name="parent_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $parent;

	/**
	 * @Gedmo\TreeLeft
	 * @ORM\Column(name="lft", type="integer")
	 */
	private $lft;

	/**
	 * @Gedmo\TreeLevel
	 * @ORM\Column(name="lvl", type="integer")
	 */
	private $lvl;

	/**
	 * @Gedmo\TreeRight
	 * @ORM\Column(name="rgt", type="integer")
	 */
	private $rgt;

	/**
	 * @Gedmo\TreeRoot
	 * @ORM\ManyToOne(targetEntity="GeneralGroup")
	 * @ORM\JoinColumn(name="tree_root", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $root;

	public function __construct($title)
	{
		$this->title       = $title;
		$this->isPublished = 1;
		$this->references  = new ArrayCollection();
		$this->children    = new ArrayCollection();
	}

	/******
	 * === References
	 */

	/**
	 * @return ArrayCollection|General[]
	 */
	public function getReferences() { return $this->references; }

	public function setReferences($references)
	{
		$this->references = new ArrayCollection($references);
	}

	public function addReference($reference)
	{
		if ($this->references->contains($reference)) {
			return true;
		}

		return $this->references->add($reference);
	}

	public function removeReference($reference)
	{
		if ($this->references->contains($reference)) {
			return $this->references->removeElement($reference);
		}

		return true;
	}

	/******
	 * === Group
	 */

	public function getRoot()
	{
		return $this->root;
	}

	public function setParent($parent = null)
	{
		$this->parent = $parent;
	}

	public function getParent()
	{
		return $this->parent;
	}

	public function getChildren() { return $this->children; }

	public function getLevel() { return $this->lvl; }

}
