<?php declare(strict_types = 1);

namespace References\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Kdyby\Translation\Translator;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\SmartObject;

class GeneralListener implements Subscriber
{
	use SmartObject;

	/** @var Cache */
	private $navigationCache;

	/** @var Translator */
	protected $translator;

	public function __construct(IStorage $cacheStorage, Translator $translator)
	{
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->translator      = $translator;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param General            $general
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($general, $args)
	{
		$this->navigationCache->clean([Cache::TAGS => Navigations::CACHE_NAMESPACE]);
	}
}
