<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Utils\Strings;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190221141720 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE references__general ADD alias VARCHAR(255) NOT NULL');
	}

	public function postUp(Schema $schema)
	{
		$qb = $this->connection->createQueryBuilder();
		$qb->select('r.id, r.title')
			->from('references__general', 'r');
		$references = $qb->execute();

		foreach ($references as $reference) {
			$this->connection->update('references__general', [
				'alias' => Strings::webalize($reference['title']),
			], ['id' => $reference['id']]);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE references__general DROP alias');
	}
}
