<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180801010104 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE references__company_reference (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, text LONGTEXT DEFAULT NULL, image VARCHAR(255) DEFAULT NULL, url VARCHAR(255) DEFAULT NULL, is_published SMALLINT DEFAULT NULL, params LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE references__company_group_companies (reference_id INT NOT NULL, group_id INT NOT NULL, INDEX IDX_1D58E9571645DEA9 (reference_id), INDEX IDX_1D58E957FE54D947 (group_id), PRIMARY KEY(reference_id, group_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE references__company_group (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, tree_root INT DEFAULT NULL, title VARCHAR(255) NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, lft INT NOT NULL, lvl INT NOT NULL, rgt INT NOT NULL, INDEX IDX_3C3C8295727ACA70 (parent_id), INDEX IDX_3C3C8295A977936C (tree_root), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE references__personal_reference (id INT AUTO_INCREMENT NOT NULL, first_name VARCHAR(255) NOT NULL, last_name VARCHAR(255) NOT NULL, positions VARCHAR(255) DEFAULT NULL, street VARCHAR(255) DEFAULT NULL, city VARCHAR(255) DEFAULT NULL, zip VARCHAR(8) DEFAULT NULL, phone VARCHAR(255) DEFAULT NULL, email VARCHAR(60) DEFAULT NULL, image VARCHAR(255) DEFAULT NULL, age INT UNSIGNED DEFAULT NULL, text LONGTEXT DEFAULT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, params LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE references__personal_group_personals (reference_id INT NOT NULL, group_id INT NOT NULL, INDEX IDX_2658060E1645DEA9 (reference_id), INDEX IDX_2658060EFE54D947 (group_id), PRIMARY KEY(reference_id, group_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE references__personal_group (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, tree_root INT DEFAULT NULL, title VARCHAR(255) NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, lft INT NOT NULL, lvl INT NOT NULL, rgt INT NOT NULL, INDEX IDX_633CCB94727ACA70 (parent_id), INDEX IDX_633CCB94A977936C (tree_root), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE references__general (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, image VARCHAR(255) DEFAULT NULL, introtext VARCHAR(255) DEFAULT NULL, is_published SMALLINT NOT NULL, template VARCHAR(255) NOT NULL, texts LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE references__general_group_generals (reference_id INT NOT NULL, group_id INT NOT NULL, INDEX IDX_AF41B7A31645DEA9 (reference_id), INDEX IDX_AF41B7A3FE54D947 (group_id), PRIMARY KEY(reference_id, group_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE references__general_group (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, tree_root INT DEFAULT NULL, title VARCHAR(255) NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, lft INT NOT NULL, lvl INT NOT NULL, rgt INT NOT NULL, INDEX IDX_375CF3BE727ACA70 (parent_id), INDEX IDX_375CF3BEA977936C (tree_root), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');

		$this->addSql('ALTER TABLE references__company_group_companies ADD CONSTRAINT FK_1D58E9571645DEA9 FOREIGN KEY (reference_id) REFERENCES references__company_reference (id)');
		$this->addSql('ALTER TABLE references__company_group_companies ADD CONSTRAINT FK_1D58E957FE54D947 FOREIGN KEY (group_id) REFERENCES references__company_group (id)');
		$this->addSql('ALTER TABLE references__company_group ADD CONSTRAINT FK_3C3C8295727ACA70 FOREIGN KEY (parent_id) REFERENCES references__company_group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE references__company_group ADD CONSTRAINT FK_3C3C8295A977936C FOREIGN KEY (tree_root) REFERENCES references__company_group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE references__personal_group_personals ADD CONSTRAINT FK_2658060E1645DEA9 FOREIGN KEY (reference_id) REFERENCES references__personal_reference (id)');
		$this->addSql('ALTER TABLE references__personal_group_personals ADD CONSTRAINT FK_2658060EFE54D947 FOREIGN KEY (group_id) REFERENCES references__personal_group (id)');
		$this->addSql('ALTER TABLE references__personal_group ADD CONSTRAINT FK_633CCB94727ACA70 FOREIGN KEY (parent_id) REFERENCES references__personal_group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE references__personal_group ADD CONSTRAINT FK_633CCB94A977936C FOREIGN KEY (tree_root) REFERENCES references__personal_group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE references__general_group_generals ADD CONSTRAINT FK_AF41B7A31645DEA9 FOREIGN KEY (reference_id) REFERENCES references__general (id)');
		$this->addSql('ALTER TABLE references__general_group_generals ADD CONSTRAINT FK_AF41B7A3FE54D947 FOREIGN KEY (group_id) REFERENCES references__general_group (id)');
		$this->addSql('ALTER TABLE references__general_group ADD CONSTRAINT FK_375CF3BE727ACA70 FOREIGN KEY (parent_id) REFERENCES references__general_group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE references__general_group ADD CONSTRAINT FK_375CF3BEA977936C FOREIGN KEY (tree_root) REFERENCES references__general_group (id) ON DELETE CASCADE');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE references__company_group_companies DROP FOREIGN KEY FK_1D58E9571645DEA9');
		$this->addSql('ALTER TABLE references__company_group_companies DROP FOREIGN KEY FK_1D58E957FE54D947');
		$this->addSql('ALTER TABLE references__company_group DROP FOREIGN KEY FK_3C3C8295727ACA70');
		$this->addSql('ALTER TABLE references__company_group DROP FOREIGN KEY FK_3C3C8295A977936C');
		$this->addSql('ALTER TABLE references__personal_group_personals DROP FOREIGN KEY FK_2658060E1645DEA9');
		$this->addSql('ALTER TABLE references__personal_group_personals DROP FOREIGN KEY FK_2658060EFE54D947');
		$this->addSql('ALTER TABLE references__personal_group DROP FOREIGN KEY FK_633CCB94727ACA70');
		$this->addSql('ALTER TABLE references__personal_group DROP FOREIGN KEY FK_633CCB94A977936C');
		$this->addSql('ALTER TABLE references__general_group_generals DROP FOREIGN KEY FK_AF41B7A31645DEA9');
		$this->addSql('ALTER TABLE references__general_group_generals DROP FOREIGN KEY FK_AF41B7A3FE54D947');
		$this->addSql('ALTER TABLE references__general_group DROP FOREIGN KEY FK_375CF3BE727ACA70');
		$this->addSql('ALTER TABLE references__general_group DROP FOREIGN KEY FK_375CF3BEA977936C');

		$this->addSql('DROP TABLE references__company_reference');
		$this->addSql('DROP TABLE references__company_group_companies');
		$this->addSql('DROP TABLE references__company_group');
		$this->addSql('DROP TABLE references__personal_reference');
		$this->addSql('DROP TABLE references__personal_group_personals');
		$this->addSql('DROP TABLE references__personal_group');
		$this->addSql('DROP TABLE references__general');
		$this->addSql('DROP TABLE references__general_group_generals');
		$this->addSql('DROP TABLE references__general_group');
	}
}
