<?php declare(strict_types = 1);

namespace References\FrontModule\Model;

use Core\Model\Helpers\Arrays;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Entities\Repository\NestedTreeRepository;
use References\Model\Entities\GeneralGroup;
use References\FrontModule\Model\Dao as DaoReferences;

/**
 * Class GeneralGroups
 * @package References\FrontModule\Model
 *
 * @method GeneralGroup|object|null getReference($id)
 * @method GeneralGroup|null get($id)
 * @method NestedTreeRepository getEr()
 */
class GeneralGroups extends BaseEntityService
{
	protected $entityClass = GeneralGroup::class;

	public function getTree()
	{
		$query = $this->getEr()->createQueryBuilder('g')->orderBy('g.root, g.lft', 'ASC')
			->getQuery()->useResultCache(true, 120);
		return $this->fillDao($this->getEr()->buildTree($query->getArrayResult()));
	}

	/**
	 * @param array $groupsRaw
	 *
	 * @return DaoReferences\Group[]
	 */
	public function fillDao($groupsRaw, $parent = null)
	{
		$groups = [];

		foreach ($groupsRaw as $group) {
			$g = (new DaoReferences\Group())
				->setId($group['id'])
				->setTitle($group['title']);

			if ($parent)
				$g->setParent($parent);

			if ($group['__children']) {
				$g->setChilds($this->fillDao($group['__children']), $g);
			}

			$groups[$g->id] = $g;
		}

		return $groups;
	}
}